/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.decorations;

import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xueluoanping.teastory.registry.BlockRegister;

public class HaystackBlock
extends Block {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final VoxelShape LOWER_SHAPE;
    public static final VoxelShape UPPER_SHAPE;

    public HaystackBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 60 : 0;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 60 : 0;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{HALF}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? LOWER_SHAPE : UPPER_SHAPE;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.m_61143_(HALF);
        if (facing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.m_60734_() instanceof HaystackBlock && facingState.m_61143_(HALF) != doubleblockhalf ? stateIn : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected static void removeBottomHalf(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = world.m_8055_(blockpos = pos.m_7495_())).m_60734_() == state.m_60734_() && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.m_5776_() && player.m_7500_()) {
            HaystackBlock.removeBottomHalf(worldIn, pos, state, player);
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        if (blockpos.m_123342_() < 255 && context.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(context)) {
            return (BlockState)super.m_5573_(context).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = worldIn.m_8055_(blockpos);
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? blockstate.m_60783_((BlockGetter)worldIn, blockpos, Direction.UP) : blockstate.m_60713_((Block)this);
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            Holder biome = worldIn.m_204166_(pos);
            int humidity = HaystackBlock.getHumid(((Biome)biome.get()).getModifiedClimateSettings().f_47683_(), ((Biome)biome.get()).m_47505_(pos));
            if (state.m_60713_((Block)BlockRegister.WET_HAYSTACK.get()) && random.m_188503_(60 / (6 - humidity)) == 0) {
                worldIn.m_7731_(pos, (BlockState)((Block)BlockRegister.WET_HAYSTACK.get()).m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER), 2);
                worldIn.m_7731_(pos.m_7494_(), (BlockState)((Block)BlockRegister.DRY_HAYSTACK.get()).m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
            }
        }
    }

    public static int getHumid(float rainfall, float temperature) {
        int rOrder = (int)(Mth.m_14036_((float)rainfall, (float)0.0f, (float)1.0f) * 5.0f);
        int tOrder = (int)(Mth.m_14036_((float)temperature, (float)0.0f, (float)1.0f) * 6.0f);
        int level = Math.max(0, rOrder - Math.abs(rOrder - tOrder) / 2);
        return level;
    }

    static {
        VoxelShape bottom = VoxelShapeHelper.createVoxelShape(3.0, 0.0, 3.0, 10.0, 8.0, 10.0);
        VoxelShape topBottom = VoxelShapeHelper.createVoxelShape(5.0, 8.0, 5.0, 6.0, 8.0, 6.0);
        LOWER_SHAPE = Shapes.m_83110_((VoxelShape)bottom, (VoxelShape)topBottom);
        UPPER_SHAPE = VoxelShapeHelper.createVoxelShape(5.0, 0.0, 5.0, 6.0, 8.0, 6.0);
    }
}

